*****************************************************
// RD interaction spec
*****************************************************
global texfile "$output\table_diagnoses.tex"
global cluster age //used in boottest code
global controls  

global orderbw5 X1
global orderbw10 X1 

use "$data\ndhsfile", clear
rename ill_hypertension1 ill_hyper1
* Create mock column
qui reg phicmem 
  est stor fmock

* Estimate first-stage regression


 cap matrix drop stats
 global flist
foreach yvar in ill_chronic ill_acute ill_hyper1 ill_diabetes1 ill_cancer1    {
	
	 
	foreach b in 10 { 
		local fX ${orderbw`b'}
		foreach y in 2013 2017 { 


				  reg `yvar' 1.D#c.(`fX') 1.D c.`fX' $controls if inrange(X1, -`b', `b'-1) & year==`y', cluster(hhid )

					 qui estadd ysumm
					 qui estadd scalar year = `y'
					 global name  f`yvar'`f'_b`b'_y`y'
					 qui est store $name
					mat statsX =   `e(ymean)' \ `=e(N)'
					mat stats = nullmat(stats), statsX 	
				reg `yvar' 1.D#c.(`fX') 1.D c.`fX' $controls if inrange(X1, -`b', `b'-1) & year==`y', cluster($cluster )
					do "$code\boottest_output"
					global flist ${flist} f`yvar'_b`b'_y`y'
					
		 } 
	 }
 }

mat rowname stats =  "Mean of Dep. Var." "\$ N\$"
 
* Capture column-wise scalars

 

* Print table in latex 
local latex_opt_top  ///  
	prehead( ///
		"\begin{tabular}{l*{@M}{rr}}" ///
		"\hline" ///
		"\hline" ///
		) ///
	posthead( ///
		" & \multicolumn{2}{c}{\shortstack{Chronic \\ Condition}} & \multicolumn{2}{c}{\shortstack{Acute\\Condition}} & \multicolumn{2}{c}{\shortstack{Hypertension\\}} & \multicolumn{2}{c}{\shortstack{Diabetes\\}} & \multicolumn{2}{c}{\shortstack{Cancer\\}}  \\" ///
		" Year & 2013 & 2017 & 2013 & 2017 & 2013 & 2017 & 2013 & 2017 & 2013 & 2017  \\" ///
		"\hline" ///
		"\hline" ///
		"& \multicolumn{@M}{c}{} \\" ///
		)
local latex_opt_end  ///
	prefoot( ///
		"\hline" ///
		) ///
	postfoot( ///
		"\hline" ///
		"\end{tabular}" ///
		)
		
		
		
local labopt_est  keep(1.D) cells(b(fmt(3)) se(star fmt(3) par) boot_pval( fmt(2) par([ ]))) collabels(none) varw(17) style(tex) 
local labopt_est0 mlabel(none) `latex_opt_top' replace 
local labopt_estX mlabel(none) append
local labopt_fin  mlabel(none) collabels(none) modelw(15) varw(17) style(tex) `latex_opt_end' append

estout $flist using "$texfile", `labopt_est' `labopt_est0' varlabel(1.D "Age 60 and Older") starlevels(* 0.1 ** 0.05 *** 0.01)
estout matrix(stats, fmt(a2)) using "$texfile", `labopt_fin' 

